/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.container.fluid;

import com.technicalitiesmc.lib.container.fluid.FluidContainerSlice;
import com.technicalitiesmc.lib.container.fluid.adapter.FluidContainerToFluidHandlerAdapter;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Contract;

public interface FluidContainer {
    @Contract(pure=true)
    public int size();

    @Nonnull
    @Contract(pure=true)
    public FluidStack get(int var1);

    public void set(int var1, @Nonnull FluidStack var2);

    @Contract(pure=true)
    public boolean isValid(int var1, @Nonnull FluidStack var2);

    @Contract(pure=true)
    public int getCapacity(int var1);

    default public void clear() {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, FluidStack.EMPTY);
        }
    }

    @Contract(pure=true)
    default public boolean isEmpty() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    @Contract(value="_, _ -> new", pure=true)
    default public FluidContainer slice(int from, int to) {
        Objects.checkFromToIndex(from, to, this.size());
        return new FluidContainerSlice(this, from, to - from);
    }

    @Nonnull
    @Contract(value="-> new", pure=true)
    default public IFluidHandler asFluidHandler() {
        return new FluidContainerToFluidHandlerAdapter(this);
    }
}

